#!/bin/bash

$g_ExistNginx
$g_ExistApache


#check Nginx
function check_Nginx()
{
	g_ExistNginx="false"

	#"checking nginx process"
	for progname in nginx  
	do 			
		g_NginxExePath=`ps -ef | grep $progname | grep master | awk '{print $11}'`
		if [ ! -z $g_NginxExePath ];then
			g_ExistNginx="true"
		fi
	done	
}


#check apache
function check_apache()
{
	for progname in httpd apache2 apached
	do 		
		#checking apache service
		testcmd="service "$progname" status"
		$testcmd>/dev/null 2>&1
		ret=$?
		if [ "$ret" == "0" ] || [ "$ret" == "2" ] || [ "$ret" == "3" ]; then
			g_ExistApache="true"
			return  1
		else
			testcmd="service "$progname" stop"
			$testcmd>/dev/null 2>&1
			ret=$?
			if [ "$ret" == "0" ]; then
				g_ExistApache="true"
				return  1
			fi
		fi
		
		#"checking apache process"
		g_ApacheExePath=`ps -ef | grep $progname | grep -v grep | tail -3 | head -1 | awk '{print $8}'`
		if [ ! -z $g_ApacheExePath ];then
			g_ExistApache="true"
			return 1
		fi
		
	done

	# not found
	g_ExistApache="false"
}

check_Nginx
check_apache

if [ $g_ExistNginx == "false" ] && [ $g_ExistApache == "true" ];then
	echo 1
#echo $g_ExistNginx
#	echo $g_ExistApache
	exit 1
fi


if [ $g_ExistNginx == "true" ] && [ $g_ExistApache == "false" ];then
	echo 2
	exit 2
fi

echo 3
exit 3
