local require = GLOBAL.require
--
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local STRINGS = GLOBAL.STRINGS

STRINGS.NAMES.WINONA = "Winona"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.WINONA = "Will update with their quotes for Winona for you console-spawners."

PrefabFiles = {
	"winona",
	"sewing_tape",
}

Assets = { 
    Asset( "IMAGE", "images/saveslot_portraits/winona.tex" ),
    Asset( "IMAGE", "images/selectscreen_portraits/winona.tex" ),
    Asset( "IMAGE", "images/selectscreen_portraits/winona_silho.tex" ),
    Asset( "IMAGE", "bigportraits/winona.tex" ),
	Asset( "IMAGE", "images/winona.tex" ),
	Asset( "IMAGE", "minimap/winona.tex" ),
	Asset( "IMAGE", "images/inventoryimages/sewing_tape.tex" ),
	Asset( "ATLAS", "images/inventoryimages/sewing_tape.xml" ),
    Asset( "ATLAS", "images/saveslot_portraits/winona.xml" ),
    Asset( "ATLAS", "images/selectscreen_portraits/winona.xml" ),
    Asset( "ATLAS", "images/selectscreen_portraits/winona_silho.xml" ),
    Asset( "ATLAS", "bigportraits/winona.xml" ),
	Asset( "ATLAS", "images/winona.xml" ),
	Asset( "ATLAS", "minimap/winona.xml" ),
	Asset("SOUNDPACKAGE", "sound/winona.fev"),	
	Asset("SOUND", "sound/winona.fsb"),
}

AddMinimapAtlas("minimap/winona.xml")
AddMinimapAtlas("images/winona.xml")

RemapSoundEvent( "dontstarve/characters/winona/death_voice", "winona/characters/winona/death_voice" )
RemapSoundEvent( "dontstarve/characters/winona/hurt", "winona/characters/winona/hurt" )
RemapSoundEvent( "dontstarve/characters/winona/talk_LP", "winona/characters/winona/talk_LP" )

local sewing_taperecipe = GLOBAL.Recipe( "sewing_tape", { Ingredient("silk", 1), Ingredient("cutgrass", 3)}, RECIPETABS.DRESS, nil, nil, nil, nil, nil, "handyperson")
sewing_taperecipe.sortkey = -600
sewing_taperecipe.atlas = "images/inventoryimages/sewing_tape.xml"
--------------------------------------------------------------------
STRINGS.NAMES.SEWING_TAPE = "Trusty Tape"
STRINGS.RECIPE_DESC.SEWING_TAPE = "Patch up degraded clothing items."
--------------------------------------------------------------------
STRINGS.CHARACTER_TITLES.winona = "The Handywoman"
STRINGS.CHARACTER_NAMES.winona = "Winona"
STRINGS.CHARACTER_DESCRIPTIONS.winona = "*Is a skilled builder\n*Gets one free hit from the dark\n*Brings her own tools"
STRINGS.CHARACTER_QUOTES.winona = "Anything can be fixed with hard work and elbow grease."
--------------------------------------------------------------------
STRINGS.CHARACTERS.WINONA = require "speech_winona"

table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "winona")

AddModCharacter("winona")