local assets =
{
    Asset("ANIM", "anim/sewing_tape.zip"),
	Asset("IMAGE", "images/inventoryimages/sewing_tape.tex"),
	Asset("ATLAS", "images/inventoryimages/sewing_tape.xml"),
}

local function onsewn(inst, target, doer)
    doer:PushEvent("repair")
	if inst.components.stackable.stacksize > 1 then
		inst.components.stackable.stacksize = inst.components.stackable.stacksize - 1
	else
		inst:Remove()
	end
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("tape")
    inst.AnimState:SetBuild("sewing_tape")
    inst.AnimState:PlayAnimation("idle")

	inst:AddTag("tape")

    --[[if not TheWorld.ismastersim then
        return inst
    end]]--

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("sewing")
    inst.components.sewing.repair_value = TUNING.SEWINGKIT_REPAIR_VALUE
    inst.components.sewing.onsewn = onsewn
    ---------------------       

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/sewing_tape.xml"

    return inst
end

return Prefab("sewing_tape", fn, assets)