require "stategraphs/SGwinona"

local MakePlayerCharacter = require("prefabs/player_common")

local assets =
{
    Asset( "ANIM", "anim/player_basic.zip" ),
    Asset( "ANIM", "anim/player_idles_shiver.zip" ),
    Asset( "ANIM", "anim/player_actions.zip" ),
    Asset( "ANIM", "anim/player_actions_axe.zip" ),
    Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
    Asset( "ANIM", "anim/player_actions_shovel.zip" ),
    Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
    Asset( "ANIM", "anim/player_actions_eat.zip" ),
    Asset( "ANIM", "anim/player_actions_item.zip" ),
    Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
    Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
    Asset( "ANIM", "anim/player_actions_fishing.zip" ),
    Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
    Asset( "ANIM", "anim/player_bush_hat.zip" ),
    Asset( "ANIM", "anim/player_attacks.zip" ),
    Asset( "ANIM", "anim/player_idles.zip" ),
    Asset( "ANIM", "anim/player_rebirth.zip" ),
    Asset( "ANIM", "anim/player_jump.zip" ),
    Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
    Asset( "ANIM", "anim/player_teleport.zip" ),
    Asset( "ANIM", "anim/wilson_fx.zip" ),
    Asset( "ANIM", "anim/player_one_man_band.zip" ),
    Asset( "ANIM", "anim/shadow_hands.zip" ),
    Asset( "SOUND", "sound/sfx.fsb" ),
	---
	Asset("ANIM", "anim/winona.zip"),
    Asset("SOUND", "sound/winona.fsb"),
}

local prefabs =
{
    "sewing_tape",
}

local start_inv =
{
    "sewing_tape",
    "sewing_tape",
    "sewing_tape",
}

local resistgrue = function(inst)
	inst.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_CHARLIE_MISSED"))
	inst:RemoveTag("uglystepsister")
end

local fn = function(inst)
	inst.soundsname = "winona"
	inst:SetStateGraph("SGwinona")
	
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( "winona.tex" )
	
	local light_thresh = .5
	local dark_thresh = .5
	
	inst:AddTag("voxolaworker")
	
	if inst.LightWatcher:IsInLight() then
		if inst.LightWatcher:GetTimeInLight() >= light_thresh then
			inst:AddTag("uglystepsister")
			print("Back in the light!")
		end
	end
	
	if inst.inlight then
		inst:AddTag("uglystepsister")
		print("Back to light!")
	end
	
	inst:ListenForEvent("resistedgrue", resistgrue)

    inst.AnimState:Hide("HAT")
    inst.AnimState:Hide("HAIR_HAT")
    inst.AnimState:Show("HAIR_NOHAT")
    inst.AnimState:Show("HAIR")
    inst.AnimState:Show("HEAD")
    inst.AnimState:Hide("HEAD_HAT")
	
	inst.components.health:SetMaxHealth(150)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(200)
	
	inst:AddTag("handyperson")
	inst:AddTag("fastbuilder")
    --inst.components.grue:SetResistance(1)
	
end

--return MakePlayerCharacter("winona", prefabs, assets, common_postinit, master_postinit, start_inv)
return MakePlayerCharacter("winona", prefabs, assets, fn, start_inv)
